/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWStepRuleSubPanel
extends JPanel
implements IVWListUpdateListener {
    protected static final int TYPE_PRE = 0;
    protected static final int TYPE_ON_SAVE = 1;
    protected static final int TYPE_POST = 2;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_mapNode = null;
    private int m_nRuleSetType = -1;
    private VWAddRemovePanel m_addRemovePanel = null;

    public VWStepRuleSubPanel(VWAuthPropertyData authPropertyData, int nRuleSetType) {
        this.m_authPropertyData = authPropertyData;
        this.m_nRuleSetType = nRuleSetType;
        this.createControls();
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        switch (nEventType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.updateMapNode();
            }
        }
    }

    public void setSelectedStep(VWMapNode newMapNode) {
        if (this.m_mapNode != null && this.m_mapNode == newMapNode) {
            return;
        }
        this.m_mapNode = newMapNode;
        this.reinitialize();
    }

    protected void reinitialize() {
        try {
            Object[] availableRuleSets = null;
            VWRuleSetDefinition[] selectedRuleSets = null;
            if (this.m_authPropertyData != null && this.m_mapNode != null) {
                availableRuleSets = this.m_authPropertyData.getRuleSets();
                String[] selectedRuleSetNames = this.m_mapNode.getRuleSetNames(this.m_nRuleSetType);
                selectedRuleSets = this.m_authPropertyData.getRuleSetsByName(selectedRuleSetNames);
            }
            this.m_addRemovePanel.removeListUpdateListener(this);
            this.m_addRemovePanel.initializeLists(availableRuleSets, selectedRuleSets);
            this.m_addRemovePanel.addListUpdateListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeListUpdateListener(this);
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        this.m_authPropertyData = null;
        this.m_mapNode = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 5, 0, 20);
            this.m_addRemovePanel = new VWAddRemovePanel(53);
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableRuleSets);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedRuleSets);
            this.m_addRemovePanel.enableSorting(256);
            this.m_addRemovePanel.addListUpdateListener(this);
            this.add((Component)this.m_addRemovePanel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateMapNode() {
        try {
            if (this.m_mapNode != null && this.m_nRuleSetType != -1) {
                Vector<String> tempRuleSetNames = new Vector<String>();
                Object[] selectedItems = this.m_addRemovePanel.getSelectedItems();
                if (selectedItems != null && selectedItems.length > 0) {
                    for (int i = 0; i < selectedItems.length; ++i) {
                        tempRuleSetNames.addElement(((VWRuleSetDefinition)selectedItems[i]).getName());
                    }
                }
                Object[] ruleSetDefNames = new String[tempRuleSetNames.size()];
                tempRuleSetNames.copyInto(ruleSetDefNames);
                this.m_mapNode.setRuleSets(this.m_nRuleSetType, (String[])ruleSetDefNames);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

